//
//  BankingHomeScreenController.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 29.05.22.
//

import UIKit
import CodeScanner
import JNGradientLabel  // .package(url: "https://github.com/SomeRandomiOSDev/JNGradientLabel.git", from: "1.0.0")

import WhatsNewKit // https://github.com/SvenTiigi/WhatsNewKit.git

class UserSettingsViewController: UIViewController {
    
    @IBOutlet weak var topBarLabel: JNGradientLabel!
    
    
    @IBOutlet var showAccountsButton: UIButton!
    
    @IBOutlet var showUserProfileButton: UIButton!
    
    @IBOutlet var securityAndLoginButton: UIButton!
    
    
    
    @IBOutlet weak var whatsNewButton: UIButton!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        UINavigationBar.appearance().titleTextAttributes = [.foregroundColor : UIColor.white,
                                                            .font : Fonts.mediumFontWithSize(size: 18)]
        

        // top bar gradient color
        let gradientColors: [UIColor]    = [UIColor(red: 47.0/255.0, green: 67.0/255.0, blue: 99.0/255.0, alpha: 1.0), UIColor(red: 67/255.0, green: 114.0/255.0, blue: 196.0/255.0, alpha: 1.0)]
        let gradientlocations: [CGFloat] = [1.0, 0.0]
        
        topBarLabel.textColor = .white
        topBarLabel.textGradientLocation = .background
        topBarLabel.setAxialGradientParameters(startPoint: CGPoint(x: 0.0, y: 0.0),
                                                                endPoint: CGPoint(x: 1.0, y: 1.0),
                                                                colors: gradientColors,
                                                                locations: gradientlocations)
        
        //style all buttons
        showAccountsButton.titleLabel?.font = Fonts.mediumFontWithSize(size: 18)
        showUserProfileButton.titleLabel?.font = Fonts.mediumFontWithSize(size: 18)
        securityAndLoginButton.titleLabel?.font = Fonts.mediumFontWithSize(size: 18)
        
        
        whatsNewButton.titleLabel?.font = Fonts.mediumFontWithSize(size: 17)
        Utilities.styleFilledButtonAuthScreenGreenEdged(whatsNewButton)
    }
    
    @IBAction func showAccountsButton(_ sender: Any) {
        let navigationBarController = self.storyboard?.instantiateViewController(withIdentifier: "Test3") as! UINavigationController
        
        navigationBarController.modalPresentationStyle = .popover
        //navigationBarController.modalTransitionStyle = .crossDissolve
        
        present(navigationBarController, animated: true)

    }
    
    
    @IBAction func showUserProfile(_ sender: Any) {
        let navigationBarController = self.storyboard?.instantiateViewController(withIdentifier: "UserProfileVC") as! UINavigationController
        
        navigationBarController.modalPresentationStyle = .popover
        //navigationBarController.modalTransitionStyle = .crossDissolve
        
        present(navigationBarController, animated: true)

    }
    
    @IBAction func securityAndLoginButton(_ sender: Any) {
        let navigationBarController = self.storyboard?.instantiateViewController(withIdentifier: "LoginAndSecurityVC") as! UINavigationController
        
        navigationBarController.modalPresentationStyle = .popover
        //navigationBarController.modalTransitionStyle = .crossDissolve
        
        present(navigationBarController, animated: true)
    }
    
    
    
    @IBAction func whatsNewButton(_ sender: Any) {
        
        
        let whatsnew = WhatsNew(
            // The Version that relates to the features you want to showcase
            version: "1.0.0",
            // The title that is shown at the top
            title: "Was ist neu?",
            // The features you want to showcase
            features: [
                WhatsNew.Feature(
                    image: .init(systemName: "iphone"),
                    title: "Bedienoberfläche",
                    subtitle: "Neue übersichtlichere Bedienoberfläche."
                ),
                WhatsNew.Feature(
                    image: .init(systemName: "qrcode"),
                    title: "Scan QR Codes",
                    subtitle: "Du kannst jetzt Banking QR Codes scannen und so noch schneller und einfacher Überweisungen tätigen."
                ),
                WhatsNew.Feature(
                    image: .init(systemName: "person.circle"),
                    title: "Profil",
                    subtitle: "Profilinformationen sind jetzt abrufbar."
                )
            ],
            // The primary action that is used to dismiss the WhatsNewView
            primaryAction: WhatsNew.PrimaryAction(
                title: "Weiter",
                backgroundColor: .accentColor, //.init(UIColor(red: 47.0/255.0, green: 67.0/255.0, blue: 99.0/255.0, alpha: 1.0))
                foregroundColor: .white,
                hapticFeedback: .notification(.success),
                onDismiss: {
                    print("WhatsNewView has been dismissed")
                }
            )
            
        )
        
        let vc = WhatsNewViewController(whatsNew: whatsnew)
        
        present(vc, animated: true)

    }
    

}

extension String {

    var length: Int {
        return count
    }

    subscript (i: Int) -> String {
        return self[i ..< i + 1]
    }

    func substring(fromIndex: Int) -> String {
        return self[min(fromIndex, length) ..< length]
    }

    func substring(toIndex: Int) -> String {
        return self[0 ..< max(0, toIndex)]
    }

    subscript (r: Range<Int>) -> String {
        let range = Range(uncheckedBounds: (lower: max(0, min(length, r.lowerBound)),
                                            upper: min(length, max(0, r.upperBound))))
        let start = index(startIndex, offsetBy: range.lowerBound)
        let end = index(start, offsetBy: range.upperBound - range.lowerBound)
        return String(self[start ..< end])
    }
}
